<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../gUtil/GeneratoreEmail.php";
    include "../classi/Notifica.php";
    include "../classi/GeneratoreUrl.php";
    
    session_start();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione            = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $idForm                = filter_input(INPUT_GET,"idForm",FILTER_SANITIZE_NUMBER_INT);
        $informazioniInserite  = filter_input(INPUT_GET,"informazioniInserite",FILTER_SANITIZE_ADD_SLASHES);
    }
    else {
        $operazione            = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $idForm                = filter_input(INPUT_POST,"idForm",FILTER_SANITIZE_NUMBER_INT);
        $informazioniInserite  = filter_input(INPUT_POST,"informazioniInserite",FILTER_SANITIZE_ADD_SLASHES);
    }
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom  = $geecomDb->leggiSingolaRiga("geec_prodotti", 1) ;
    $percorsoGeecomAdmin = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
        
    //recupero i dati del destinatario della mail (ovvero l'email impostata per quel form)
    $datiForm = $geecomDb->leggiSingolaRiga("geec_form",$idForm);
    $destinatario = $datiForm["emailNotificaAmministratore"];
    
    $indirizzoSito = str_replace(array("https://www.","https://","http://www.","http://",),"",$impostazioni["urlSito"]);
    
    switch ($operazione) {
        case 'inviaEmail':

            $messaggio = "Nuovo messaggio dal modulo contatti {$datiForm["nome"]} del sito {$impostazioni["titoloSito"]}"."<br><b>Contenuto del messaggio:</b><br>$informazioniInserite";
            $oggetto   = $datiForm["oggettoNotificaAmministratore"];

            $rispondiA      = "";
            if($datiForm["rispondiA"] != "") {
                $arrayEmail   = explode($datiForm["rispondiA"].":", $informazioniInserite);
                $arrayEmail2  = explode("<br>",$arrayEmail[1]);
                $rispondiA    = trim($arrayEmail2[0]);
            }

            $generatoreEmail = new GeneratoreEmail("Geecom Cms","geecom@$indirizzoSito",$rispondiA);

            // prim controllo: verifica se è stato inserito codice javascript
            if(ControlloreStringhe::rilevaJavascript($_POST["informazioniInserite"]) ) {
                echo"Rilevato tentativo di cross site scripting: questa email non può essere inviata. Rimuovi il codice javascript dal testo.";
            }
            else if(isset($_SESSION["data"])) {
                $inviiMail = explode(" ",$_SESSION["data"]);
                $len = count($inviiMail);

                if($len>2) { //se sono state inviate più di tre mail 
                    //controlla che le ultime tre mail sono state inviate nello stesso minuto e se siamo nello stesso minuto, se si non invierà
                    //in tal caso non invierà la nuova mail
                    $minutoAttuale = date("i");
                    if($inviiMail[$len-3]==$inviiMail[$len-2] && $inviiMail[$len-2]==$inviiMail[$len-1] && $inviiMail[$len-1]==$minutoAttuale){ 
                        echo"Superato il limite di mail inviabili in un minuto, attendi qualche istante";
                        exit();
                    }
                }

                $_SESSION["data"] = $_SESSION["data"]." ".date("i"); //aggiunge il minuto corrente nella sessione

                $generatoreEmail->invia($destinatario, $oggetto, $messaggio);
                if($datiForm["paginaRingraziamento"]!=0) {
                    echo"ok";
                }
                else {
                    echo $datiForm["testoMessaggioInviato"];
                }
                aggiornaContatoreInvii($geecomDb,$idForm);
                inserisciMessaggioNelDatabase($geecomDb,$idForm,$informazioniInserite);
                creaNotifica($geecomDb,$impostazioni,$datiProdottoGeecom,$datiForm);
                inviaConfermaViaEmail($geecomDb,$datiForm,$informazioniInserite);
            }
            else { //se non è stata inviata alcuna email finora può inviare la mail senza fare controlli
                $_SESSION["data"] = date("i"); //aggiunge il minuto corrente nella sessione
                $generatoreEmail->invia($destinatario, $oggetto, $messaggio);
                echo"ok";
                aggiornaContatoreInvii($geecomDb,$idForm);
                inserisciMessaggioNelDatabase($geecomDb,$idForm,$informazioniInserite);
                creaNotifica($geecomDb,$impostazioni,$datiProdottoGeecom,$datiForm);
                inviaConfermaViaEmail($geecomDb,$datiForm,$informazioniInserite);
            }
            break;
        default: // esegue questo codice per i seguenti tipi di operazione: inserisciDatoInvio, eseguiRicerca e eseguiRicercaAjax
            $oggetto   = "Nuovo messaggio dal tuo sito {$impostazioni["titoloSito"]}";
            $messaggio = "Nuovo invio dal modulo contatti {$datiForm["nome"]} del sito {$impostazioni["titoloSito"]}"."<br><b>Contenuto del messaggio:</b><br>$informazioniInserite";
            
            if($destinatario!="") {
                $generatoreEmail = new GeneratoreEmail("Geecom Cms","geecom@$indirizzoSito",$rispondiA);
                $generatoreEmail->invia($destinatario, $oggetto, $messaggio);
            }
            
            aggiornaContatoreInvii($geecomDb,$idForm);
            inserisciMessaggioNelDatabase($geecomDb,$idForm,$informazioniInserite);
            creaNotifica($geecomDb,$impostazioni,$datiProdottoGeecom,$datiForm);
            inviaConfermaViaEmail($geecomDb,$datiForm,$informazioniInserite);
            echo"ok";
            break;
    }
       
    function aggiornaContatoreInvii($geecomDb,$idForm) {
        $query = "UPDATE geec_form SET contatoreInvii=contatoreInvii+1 WHERE id=$idForm";
        $geecomDb->eseguiQueryLettura($query);
    }
    
    function inserisciMessaggioNelDatabase($geecomDb,$idForm,$messaggio) {
        $data  = date("Y-m-d H:i:s");
        $query = "INSERT INTO geec_messaggiForm VALUES(NULL,$idForm,'$messaggio','$data')";
        $geecomDb->eseguiQueryLettura($query);
    }
    
    function creaNotifica($geecomDb,$impostazioni,$datiProdottoGeecom,$datiForm) {
        $notifica = new Notifica($geecomDb, 0);
        $notifica->setProdotto("CMS");
        $notifica->setTipo("nuovoOrdine");
        $notifica->setTesto("Nuovo messaggio dal modulo {$datiForm["nome"]}");
        $notifica->setLink(GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni, $datiProdottoGeecom)."/componenti/form/elencoMessaggi.php?id={$datiForm["id"]}");
        $notifica->crea();
    }
    
    /*
     * questa funzione invia una conferma via email a chi ha inviato il form
     * è necessario che sia stato impostato il campo campoEmailNotificaUtente
     */
    function inviaConfermaViaEmail($geecomDb,$datiForm,$informazioniInserite) {
        if($datiForm["attivaNotificaUtente"]=="si") {
            $datiEmail = $geecomDb->leggiSingolaRiga("geec_templateEmail",$datiForm["templateEmailNotificaUtente"]);
                
            $arrayEmail   = explode($datiForm["campoEmailNotificaUtente"].":", $informazioniInserite);
            $arrayEmail2  = explode("<br>",$arrayEmail[1]);
            $destinatario = trim($arrayEmail2[0]);
            $messaggio    = "Ti confermiamo la recezione messaggio, ecco i dati che hai inserito:"."<br><br>$informazioniInserite";
            
            $corpoMail = str_replace("testo_da_inserire",$messaggio,$datiEmail['corpoMail']);
            $messaggioHTML = "<!doctype html>
                    <html>
                      <head>
                        <meta name=\"viewport\" content=\"width=device-width\" />
                        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                        <title>{$datiForm["oggettoNotificaUtente"]}</title>
                        <style>
                            {$datiEmail['css']}
                        </style>
                      </head>
                      <body class=\"\">
                    </body>
                    $corpoMail
                    {$datiEmail['footerMail']}";
                    
            $generatoreEmail = new GeneratoreEmail($datiForm["nomeMittenteNotificaUtente"],$datiForm["emailMittenteNotificaUtente"]);
            $generatoreEmail->invia($destinatario, $datiForm["oggettoNotificaUtente"], $messaggioHTML);
        }
    }